set more off
global path_in ""
global path_temp ""
global path_out ""

*	Makes Table 1.

cap program drop countryrnk
program define countryrnk
	gen 		country_hier=1  if country=="AUS"
	replace 	country_hier=2  if country=="AUT"
	replace 	country_hier=3  if country=="BEL"
	replace 	country_hier=4  if country=="CAN"
	replace 	country_hier=5  if country=="DNK"
	replace 	country_hier=6  if country=="FIN"
	replace 	country_hier=7  if country=="FRA"
	replace 	country_hier=8  if country=="GER"
	replace 	country_hier=9  if country=="IRL"
	replace 	country_hier=10 if country=="ITA"
	replace 	country_hier=11 if country=="JPN"
	replace 	country_hier=12 if country=="LUX"
	replace 	country_hier=13 if country=="NLD"
	replace 	country_hier=14 if country=="PRT"
	replace 	country_hier=15 if country=="KOR"
	replace 	country_hier=16 if country=="ESP"
	replace 	country_hier=17 if country=="SWE"
	replace 	country_hier=18 if country=="UK"
	replace 	country_hier=19 if country=="USA"
	sort country_hier
end	



**1. Last eight columns of Table 1 (Average annualized change in hrs and in labor productivity by country-decade)
use $path_in\KLEMS_b2008_clean, clear
	drop if code=="TOT" /*keep sector-specific data*/
	replace laborshare=laborshare/100
	keep country code cross year VA LAB H_EMP laborshare lnH_EMP
	gen lnlaborshare=ln(laborshare)
	
	*Overall hrs
	bysort country year: egen H_EMP_ct=sum(H_EMP)
	
	*Overall laborshare
	bysort country year: egen totVA=sum(VA)
	bysort country year: egen totLAB=sum(LAB)
	gen laborshare_ct = totLAB / totVA
	
	*Defining decades
	gen 	decade=1970 if year<1980
	replace decade=1980 if year>=1980&year<1990
	replace decade=1990 if year>=1990&year<2000
	replace decade=2000 if year>=2000
	
	*Define start points for each country-decade
	bysort country decade: egen minyear=min(year) if lnlaborshare!=.
	bysort country: egen maxyear=max(year) if lnlaborshare!=.
	keep if year==minyear|year==maxyear
	
	*Define period lengths for each country-decade
	tsset cross year
	gen nryrs=year-year[_n-1]
	replace nryrs=. if nryrs<0
	
	*Construct annualized industry hrs worked share change
	cap bysort country year: egen totH_EMP=sum(H_EMP) if H_EMP!=.
	gen indshare_HRS=H_EMP/totH_EMP if H_EMP!=.
	label var indshare_HRS "Industry share of H_EMP in total H_EMP, by country-year"
		bysort country year: egen testHRS=sum(indshare_HRS) if indshare_HRS!=.
		sum testHRS/*shares sum to 1 by country-year*/
		drop testHRS
		
	*Construct annualized industry value added share change
	cap bysort country year: egen totVA=sum(VA) if VA!=.
	gen indshare_VA=VA/totVA if VA!=.
	label var indshare_VA "Industry share of VA in total VA, by country-year"
		bysort country year: egen testVA=sum(indshare_VA) if indshare_VA!=.
		sum testVA /*shares sum to 1 by country-year*/
		drop testVA
	
	*Construct annualized total laborshare level change by country-year
	replace decade=2010 if year==maxyear
	tsset cross decade

	*Construct annualized total log laborshare change by country-year
	bysort country decade: egen lnlaborshare_ct=sum(lnlaborshare*indshare_VA)
	tsset cross decade
	gen D_lnlaborshare_ct=(lnlaborshare_ct-L10.lnlaborshare_ct)/nryrs *100	
	
	*Construct annualized total log hrs worked change by country-year
	bysort country decade: egen lnhrs_ct=sum(lnH_EMP*indshare_HRS)
	tsset cross decade
	gen D_lnhrs_ct=(lnhrs_ct-L10.lnhrs_ct)/nryrs *100	

	*Drop duplicates, retain relevant variables
	duplicates drop country decade, force
	keep country decade D_lnlaborshare_ct D_lnhrs_ct
	
	*Merge in country-size weights by decade
	merge m:1 country decade using $path_in\country_weights_bydecade
	drop _
	replace decade=decade-10
	drop if D_lnlaborshare_ct==.
	
	rename D_lnlaborshare_ct Dlnls
	rename D_lnhrs_ct Dlnhrs
	
	*Calculate weighted means
	egen Dlnhrs_wtmean	=sum(Dlnhrs*weight_hrs), by(decade)
	egen Dlnls_wtmean	=sum(Dlnls*weight_ls), by(decade)		
	
	drop weight*
	reshape wide Dlnhrs Dlnls Dlnhrs_wtmean Dlnls_wtmean, i(country) j(decade)
	
	order country Dlnhrs* Dlnls*
	countryrnk
	
	*Save dataset containing last eight columns of Table 1
	save $path_out\T1.dta, replace	

	
**2. First three columns of Table 1
use $path_in\KLEMS_b2008_clean, clear
keep if code=="TOT"
	replace laborshare=laborshare/100

	foreach var in lnH_EMP laborshare {
		bysort country: egen mean`var'=mean(`var')
	}
	
	duplicates drop country, force
	keep country mean*
	
	*merge in country weights
	merge 1:1 country using $path_in\country_weights
	drop _
	keep country mean* weight_ls
	
	countryrnk
	
